﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Kz.GammaTech.Cms;
using Kz.GammaTech.X509;
// Генерация и проверка PKCS7 (CMS)
// Используется класс GostCMS из пространства имен Kz.GammaTech.Cms. Для генерации можно использовать закрытый ключ
// в виде AsymmetricKeyParameter или из PKCS12. Для проверки можно использовать сертификат, открытый ключ в виде
// AsymmetricKeyParameter. Если не указано ни то, ни другое - будет использоваться сертификат из самого CMS
// Свойства класса:
//  AsymmetricKeyParameter privateKey  - закрытый ключ для подписи
 //       
 //         X509Certificate certificate - сертификат, который будет включен в CMS. В случае использования для подписи PKCS12, должен быть null
 //        X509Certificate SignerCertificate - сертификат подписавшего CMS (заполняется только в случае удачной проверки) 
 //       byte[] input - исходные данные (для генерации - подписываемые данные, для проверки - подписанные данные)
 //       byte[] output - подписанные данные
 //        Stream pkcs12 - PKCS12 для подписи
 //       string password - пароль на PKCS12
//        string DigestOID - OID алгоритма хэширования(заполняется только в случае удачной проверки)  
//        string SignatureOID - OID алгоритма подписи(заполняется только в случае удачной проверки)  
//        byte[] Signature - подпись в виде массива байт(заполняется только в случае удачной проверки)
//        byte[] Hash - хэш в виде массива байт(заполняется только в случае удачной проверки)
//       byte[] Content - исходные подписываемые данные(заполняется только в случае удачной проверки)
//Методы класса:
// void GenerateCMS() - генерирует PKCS7 (CMS). Должны быть установлены: privateKey (или pkcs12 c паролем), input
// bool VerifyCMS() - проверяет PKCS7. Возвращает true - если подпись верна, false - если неверна. Устанавливает свойства
namespace TestCreatePkcs7
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Sign and verify test started");

            StreamReader p12 = new StreamReader("lumos.p12");
            Stream p12_base = p12.BaseStream;
            GostCMS gost_cms = new GostCMS();
            gost_cms.pkcs12 = p12_base;
            gost_cms.input = Encoding.ASCII.GetBytes("test");
            gost_cms.password = "12345";
            gost_cms.GenerateCMS();

            byte[] cms = gost_cms.output;

            gost_cms.input = gost_cms.output;
            if (gost_cms.VerifyCMS()) Console.WriteLine("Success");
            else
                Console.WriteLine("Fail");

            Console.WriteLine(gost_cms.SignatureOID);
            Console.WriteLine(gost_cms.DigestOID);
            Console.WriteLine(gost_cms.SignerCertificate.SubjectDN);

            byte[] sig = gost_cms.Signature;
            byte[] hash = gost_cms.Hash;
            byte[] content = gost_cms.Content;

            

            Console.WriteLine("Ready");
            Console.ReadKey();
        }
    }
}
